<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Book_store extends CI_Model {
    
    public function add_book($data){
        $query = $this->db->insert('store_books', $data);
        return $this->db->affected_rows();
    }


    public function add_book_stock($data){
        $query = $this->db->insert_batch('store_books', $data);
        return $this->db->affected_rows();
    }



    public function check_book($id){
        $query = $this->db->get_where('store_books', array('book_id' => $id));
        return $query;
    }

    public function get_stock(){
        $query =  $this->db->select('*')->from('store_books')->where('is_disabled', 0)->order_by('store_books.id');
        $queryRes = $this->db->get();
        return $queryRes->result_array();
    }
    
    public function getClasses(){
        $this->db->select('store_books.class')->from('store_books')->group_by("store_books.class");
        $queryRes = $this->db->get();
        return $queryRes->result_array();
    }

    public function get_stock_by_ids($data){
    
        $query = $this->db->select('*')->from('store_books')->where_in('id' , $data);
        $queryRes = $this->db->get();
        return $queryRes->result_array();
    }




    public function edit_book($id){
        $query = $this->db->get_where('store_books', array('id' => $id));
        return $query->row();
    }
    
    public function update_book($data){
        if (isset($data['id'])) {
            $this->db->where('id', $data['id']);
            $this->db->update('store_books', $data);
            return true;
        } 
        return false;
    }

    public function disable_book($data){
        if (isset($data['id'])) {

            $this->db->where('id', $data['id']);
            $this->db->update('store_books', $data);
            return true;
        } 
        return false;
    }



    public function check_book_exists($isbn){
        $this->db->where('book_id', $isbn);
        $queryRes = $this->db->get('store_books');
        if($queryRes->num_rows() > 0){
            return true;
        }else{
            return false;
        }
    }
    
    public function getLastQuantity($book_id){
        $this->db->select('quantity');
        $this->db->where('id', $book_id);
        $queryRes = $this->db->get('store_books');
        $res = $queryRes->result_array();
        //print_r($res[0]['quantity']);
        return (int)$res[0]["quantity"];
        
    }



    public function updateStockOnOrderCompltion($order){
        foreach ($order as $p){

            if($this->getLastQuantity($p['book_id']) > 0){
            $this->db->set('quantity', '`quantity`- '. $p['quantity'], FALSE);

            $this->db->where('id', $p['book_id']);

            $this->db->update('store_books');
            }
        }
    }

}
?>